<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Portfolio;
use App\Models\Stock;
use App\Models\Board;
use App\Models\Trade;
use App\Models\Brokerage;
use App\Models\Result;
use App\Models\Program;
use App\Models\Transaction;
use Illuminate\Support\Facades\Auth;

use DB;


class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
      //Board Data //
        $boardData = Board::latest()->get();
      //Admin Dashboard

      //Student Dashboard //
      $student_portfolio = Auth::user()->portfolio()->get();


      //Total Batch Program
      $total_batch_program =  Program::get()->count();

      //Total Batch
      $program =  Program::latest()->take(3)->get();

      //Total Student
      $total_student = DB::table('model_has_roles')
      ->join('roles', 'roles.id', '=', 'model_has_roles.role_id')
      ->where('role_id', '2')
      ->get()
      ->count();

      //New Users
      $new_student = DB::table('programs')
     ->join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
    ->join('users', 'batchusers.user_id', '=', 'users.id')
    ->orderBy('batchusers.id','desc')->take(3)->get();

      $programs = Program::join('batchusers', 'batchusers.batch_id', '=', 'programs.id')
      ->join('users', 'batchusers.user_id', '=', 'users.id')
      ->join('portfolios', 'portfolios.user_id', '=', 'users.id')
      ->orderBy('total_profit', 'desc')
      ->get();

      //$result = Result::all();
      //$trade = Trade::all();

      $result = Auth::user()->result()->get();
      $trade = Auth::user()->result()->get();
      
      $stock = DB::table('stocks') ->get() ->count();
      $total_brokerage = DB::table('brokerages') ->get() ->count();


      //return $programs;
        return view('home', compact('total_brokerage','stock','result','trade','boardData','programs','student_portfolio','total_batch_program','total_student','program','new_student'));

    }
}
