<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\Models\User;
use App\Models\Program;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules\Password;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Auth\AuthenticationException;
use Carbon\Carbon;
use Exception;
use Request;
use Response;
use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Illuminate\Validation\ValidationException;



class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'batch_id' => ['required'],
            'password' => [
              'required', 'string', 'confirmed',
              Password::min(8)->letters()->numbers()->mixedCase()->symbols()->uncompromised(),
            ],
        ]);

    }

    public function showRegistrationForm()
    {
    $data = Program::all();
    return view('auth.register', compact('data'));
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\Models\User
     */
     protected function create(array $data)
     {
           $batch_code = DB::table('programs')
           ->where('id', $data['batch_id'] )
                   ->pluck('program_code')
                   ->first();

           if ($batch_code == $data['batch_code'] )
           {
             $user = User::create([
                       'name' => $data['name'],
                       'email' => $data['email'],
                       'password' => bcrypt($data['password']),
                   ]);

                   $user->assignRole('student');
                   $user->UserInfo = DB::table('users')
                   ->where ('id' ,$user->id)
                     ->update([
                    'phone' =>$data['phone'],
                ]);

                   $user->Batchuser = DB::table('batchusers')
                     ->insert([
                    'user_id' => $user->id,
                    'batch_id' => $data['batch_id'],
                    'created_at' => Carbon::now(),

                ]);

                $user_quantity = DB::table('batchusers')
                ->where('batch_id', $data['batch_id'] )
                        ->count();


                $user->Program = DB::table('programs')
                ->where('id', $data['batch_id'] )
                  ->update([
                 'user_quantity' => $user_quantity,

             ]);
                   return $user;
           }
           elseif ($batch_code != $data['batch_code'])
           {
          //throw new AuthenticationException('You must login to access this page.', [], '/register');
          throw ValidationException::withMessages(['Invalid Batch Code ']);
          //return redirect()->back()
          //    ->with('success','Stocks created successfully.');

           }

   }
}
